local StatsP1 = GAMESTATE:IsPlayerEnabled(PLAYER_1) and IsStatsVisible(PLAYER_1) and GAMESTATE:GetNumPlayersEnabled() == 1 and not GAMESTATE:IsDemonstration()

local function GetDifficultyColor(pn)
	local IsStepsOrTrail
	
	if GetCurrentSteps(pn) == nil then
		return "Difficulty_Edit"
	else
		IsStepsOrTrail = GetCurrentStepsOrTrail(pn)
	end

	local GetSteps = IsStepsOrTrail
	local difficulty = GetSteps:GetDifficulty()
	return difficulty
end

local function GetDifficulty(pn)
	local IsStepsOrTrail
	
	if GetCurrentSteps(pn) == nil then
		return nil
	else
		IsStepsOrTrail = GetCurrentStepsOrTrail(pn)
	end

	local GetSteps = IsStepsOrTrail
	local difficulty = GetSteps:GetDifficulty()
	local ToDiff
	
	if difficulty == "Difficulty_Beginner" then
		ToDiff = "NOVICE"
	elseif difficulty == "Difficulty_Easy" then
		ToDiff = "EASY"
	elseif difficulty == "Difficulty_Medium" then
		ToDiff = "MEDIUM"
	elseif difficulty == "Difficulty_Hard" then
		ToDiff = "HARD"
	elseif difficulty == "Difficulty_Challenge" then
		ToDiff = "EXPERT"
	elseif difficulty and GetSteps:IsAnEdit() then
		ToDiff = GetSteps:GetChartName()
	end
	return ToDiff
end

local function GetMeter(pn)
	local IsStepsOrTrail
	
	if GetCurrentSteps(pn) == nil then
		return nil
	else
		IsStepsOrTrail = GetCurrentStepsOrTrail(pn)
	end

	local GetSteps = IsStepsOrTrail
	local Meter = GetSteps:GetMeter()

	return Meter
end

local function GetStuffs(pn)
	local Steps = GetCurrentStepsOrTrail(pn)

	local ChartName = Steps:GetChartName()
	local Description = Steps:GetDescription()
	local Diff = GetDifficulty(PLAYER_1)
	local Meter = GetMeter(PLAYER_1)
	local Style = GetCurrentStyle():GetName()
	
	if Description == "" then
		Description = "Untitled"
	end
	
	if ChartName == "" then
		ChartName = "Untitled"
	end
	
	return Diff .. " " .. round(Meter * RateModUpdateFunction()) .. " / " .. Style .. " / " .. Description .. " / " .. ChartName
end

local t = Def.ActorFrame{
	BeginCommand=cmd(draworder,999;visible,StatsP1);
	-- Background
	Def.Quad {
		InitCommand=cmd(x,Right();y,Top()+76;halign,1;zoomto,462,18;diffuse,CustomDifficultyToColor(GetDifficultyColor(PLAYER_1)));
		OffCommand=cmd(diffusealpha,1;decelerate,3;diffusealpha,0);
	};
	LoadFont("Common Normal")..{
		Name="P1 Steps Chart";
		BeginCommand=cmd(x,CenterX()+196;y,Top()+76;diffuse,Black();zoom,0.45;uppercase,true;maxwidth,1000);
		OnCommand=function(self)
			self:settext(GetStuffs(PLAYER_1))
		end;
	};
	Def.Quad {
		InitCommand=cmd(x,Right();y,Bottom()-54-22;halign,1;zoomto,462,18;diffuse,ColorDarkTone(White());diffusealpha,0.7);
		OffCommand=cmd(diffusealpha,1;decelerate,3;diffusealpha,0);
	};
	Def.Quad {
		InitCommand=cmd(x,Right();y,Bottom()-54;halign,1;zoomto,462,18;diffuse,ColorDarkTone(White());diffusealpha,0.7);
		OffCommand=cmd(diffusealpha,1;decelerate,3;diffusealpha,0);
	};
};

return t;